(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12913,        427]*)
(*NotebookOutlinePosition[     13814,        457]*)
(*  CellTagsIndexPosition[     13770,        453]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[
"Cauchy-Euler\nto\nConstant Coefficients"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "A Cauchy-Euler differential operator has the form\n\t\t\t\t",
  StyleBox["CE[x_,y_]:=Sum[a[i] x^i D[y[x], {x,i}], {i,0,n}]",
    FontWeight->"Bold"],
  "\nand a Cauchy-Euler differential equation has the form CE[x,y]==f[x].\nAs \
we have seen, the Kernel of Cauchy-Euler equations can be found by letting \
y[x_]=x^r, seeing that CE[x,y]==p[r]*x^r, and finding all possible values of  \
r  from the resulting polynomial equation p[r]==0.\nBut one can also convert \
equations of this type to linear constant coefficient equations which can be \
solved by standard methods, and then converting the answer back to the \
original context.  Here is how to do this."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The Theory (by example)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[x, y, u, w]\)], "Input"],

Cell[CellGroupData[{

Cell[TextData["The operator & its order"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Given the Cauchy-Euler operator:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(CEx[x_, y_]\), ":=", 
      RowBox[{
        RowBox[{\(x\^2\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"5", " ", "x", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(4\ y[x]\)}]}]], "Input",
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"algebraic", "=", 
      RowBox[{\(CEx[x, y]\), "/.", 
        RowBox[{"{", 
          RowBox[{\(y[x] \[Rule] \(u[0]\)[x]\), ",", 
            RowBox[{
              RowBox[{\(x\^p_. \), " ", 
                RowBox[{
                  SuperscriptBox["y", 
                    TagBox[\((p_)\),
                      Derivative],
                    MultilineFunction->None], "[", "x", "]"}]}], 
              "\[Rule]", \(\(u[p]\)[x]\)}]}], "}"}]}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(4\ \(u[0]\)[x] + 5\ \(u[1]\)[x] + \(u[2]\)[x]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(order = 
      Max[Select[
          List @@ algebraic /. {\(u[p_]\)[x] \[Rule] p, 
              c_. \ \(u[p_]\)[x] \[Rule] p}, NumberQ]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Substitute"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["We make the substitution:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(x = E\^t\), "\n", 
    \(sys = 
      Table[\[PartialD]\_{t, i}w[t] == \[PartialD]\_{t, i}y[x], {i, 0, 
          order}]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^t\)], "Output"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(w[t] == y[\[ExponentialE]\^t]\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["w", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          RowBox[{\(\[ExponentialE]\^t\), " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]",
                MultilineFunction->None], "[", \(\[ExponentialE]\^t\), 
              "]"}]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["w", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          RowBox[{
            RowBox[{\(\[ExponentialE]\^t\), " ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", \(\[ExponentialE]\^t\), 
                "]"}]}], "+", 
            RowBox[{\(\[ExponentialE]\^\(2\ t\)\), " ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", \(\[ExponentialE]\^t\), 
                "]"}]}]}]}]}], "}"}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Recover y[x],...,D[y[x],x,x,...]"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Note how x=E^t,"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(sub = \(Solve[sys, 
          Table[\[PartialD]\_{x1, i}y[x1] /. x1 \[Rule] x, {i, 0, 
              order}]]\)\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", \(\[ExponentialE]\^t\), "]"}], 
          "\[Rule]", 
          RowBox[{\(-\[ExponentialE]\^\(\(-2\)\ t\)\), " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["w", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}], "-", 
                RowBox[{
                  SuperscriptBox["w", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], ")"}]}]}], 
        ",", \(y[\[ExponentialE]\^t] \[Rule] w[t]\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", \(\[ExponentialE]\^t\), "]"}], 
          "\[Rule]", 
          RowBox[{\(\[ExponentialE]\^\(-t\)\), " ", 
            RowBox[{
              SuperscriptBox["w", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}]}]}], 
      "}"}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Convert from x to t"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lt[t_, w_] = Simplify[CEx[x, y] /. sub]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(4\ w[t]\), "+", 
      RowBox[{"4", " ", 
        RowBox[{
          SuperscriptBox["w", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["w", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Find the Kernel using t & verify"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["This is the Kernel of the operator Lt:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(z[t_] = {Exp[\(-2\)\ t], t\ Exp[\(-2\)\ t]} . {c1, c2}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c1\ \[ExponentialE]\^\(\(-2\)\ t\) + 
      c2\ \[ExponentialE]\^\(\(-2\)\ t\)\ t\)], "Output"]
}, Closed]],

Cell[TextData["...As this test will show:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[Lt[t, z] == 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Get the Kernel using x & verify"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"To return to the Kernel of CEx, convert x==E^t to t==Log[x], and substitute \
into z[t]: (Clear[x] gives us back the symbol x.)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[s, x]\), "\n", 
    \(s[x_] = z[Log[x]]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c1\/x\^2 + \(c2\ Log[x]\)\/x\^2\)], "Output"]
}, Closed]],

Cell[TextData[
"The family represented by s[x] is the Kernel of CEx as this calculation \
shows:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[CEx[x, s] == 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Automate the process"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Make a single function which converts from x to t and solves in t. We do \
this by collecting the above statements into a names function."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{\(Clear[CEtoLinear, u, x, y, w, z]\), "\n", 
    RowBox[{\(CEtoLinear[operator_, y_?AtomQ, x_?AtomQ, final_?AtomQ]\), ":=",
       
      RowBox[{"Block", "[", 
        RowBox[{\({algebraic, order, sys, sub}\), ",", 
          RowBox[{
            RowBox[{"algebraic", "=", 
              RowBox[{"operator", "/.", 
                RowBox[{"{", 
                  RowBox[{\(y[x] \[Rule] \(u[0]\)[x]\), ",", 
                    RowBox[{
                      RowBox[{\(x\^p_. \), " ", 
                        RowBox[{
                          SuperscriptBox["y", 
                            TagBox[\((p_)\),
                              Derivative],
                            MultilineFunction->None], "[", "x", "]"}]}], 
                      "\[Rule]", \(\(u[p]\)[x]\)}]}], "}"}]}]}], 
            ";", \(order = 
              Max[Select[
                  List @@ algebraic /. {\(u[p_]\)[x] \[Rule] p, 
                      c_. \ \(u[p_]\)[x] \[Rule] p}, NumberQ]]\), 
            ";", \(x = E\^t\), 
            ";", \(sys = 
              Table[\[PartialD]\_{t, i}final[t] == \[PartialD]\_{t, i}y[
                      x], {i, 0, order}]\), 
            ";", \(sub = \(Solve[sys, 
                  Table[\[PartialD]\_{x1, i}y[x1] /. x1 \[Rule] x, {i, 0, 
                      order}]]\)\[LeftDoubleBracket]1\[RightDoubleBracket]\), 
            ";", \(Simplify[operator /. sub]\)}]}], "]"}]}]}], "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Try the automated process"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[Lt, x, z, q]\), "\n", 
    RowBox[{\(Lt[t_, z_]\), "=", 
      RowBox[{"CEtoLinear", "[", 
        RowBox[{
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              RowBox[{
                SuperscriptBox["y", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "+", 
            RowBox[{"5", " ", "x", " ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], 
            "+", \(4\ y[x]\)}], ",", "y", ",", "x", ",", "z"}], 
        "]"}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(4\ z[t]\), "+", 
      RowBox[{"4", " ", 
        RowBox[{
          SuperscriptBox["z", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}], "+", 
      RowBox[{
        SuperscriptBox["z", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "t", "]"}]}]], "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{549, 618},
WindowMargins->{{4, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 119, 3, 125, "Subtitle",
  Evaluatable->False],
Cell[1898, 58, 741, 13, 176, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2664, 75, 101, 2, 56, "Section",
  Evaluatable->False],
Cell[2768, 79, 50, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[2843, 84, 108, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[2954, 88, 107, 2, 32, "Text",
  Evaluatable->False],
Cell[3064, 92, 457, 12, 29, "Input"],

Cell[CellGroupData[{
Cell[3546, 108, 514, 13, 47, "Input"],
Cell[4063, 123, 79, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4179, 129, 198, 5, 75, "Input"],
Cell[4380, 136, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4464, 143, 94, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[4561, 147, 100, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4686, 153, 183, 5, 45, "Input"],
Cell[4872, 160, 52, 1, 28, "Output"],
Cell[4927, 163, 1104, 26, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6080, 195, 116, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[6199, 199, 90, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6314, 205, 215, 5, 44, "Input"],
Cell[6532, 212, 1095, 27, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7676, 245, 103, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7804, 251, 99, 2, 27, "Input"],
Cell[7906, 255, 320, 8, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8275, 269, 116, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[8394, 273, 113, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8532, 279, 114, 2, 27, "Input"],
Cell[8649, 283, 115, 2, 29, "Output"]
}, Closed]],
Cell[8779, 288, 101, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8905, 294, 83, 2, 27, "Input"],
Cell[8991, 298, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9078, 305, 115, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[9196, 309, 203, 4, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9424, 317, 107, 3, 43, "Input"],
Cell[9534, 322, 65, 1, 42, "Output"]
}, Closed]],
Cell[9614, 326, 156, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9795, 334, 84, 2, 27, "Input"],
Cell[9882, 338, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9981, 346, 98, 2, 36, "Section",
  Evaluatable->False],
Cell[10082, 350, 213, 4, 50, "Text",
  Evaluatable->False],
Cell[10298, 356, 1461, 30, 250, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[11796, 391, 103, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11924, 397, 626, 15, 47, "Input"],
Cell[12553, 414, 320, 8, 27, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

*******************************)
